/* SURVIAL PACMAN

<x>crazy pacman<x>
[move <-> don't eat the pixel]

Credits:
Code by Finn(bar Keating)
original code: https://gist.github.com/finnbar/8408455
video: http://youtu.be/ChMMsmBLSmE

Additional Code by
Tobi(as Apfelbaum)
+more level
+real random
+fixed score

more games and stuff for diy gamer (german): http://www.topfree.de/diygamer
*/

#include <Gamer.h>

Gamer gamer;

int posX=0;
int posY=0;
int ghostX=7;
int ghostY=7;
int dir=1;
int gdir=3;
int score=0;
byte level[8],level2[8],level3[8],level4[8],level5[8],level6[8];
byte numbers[10][2][8];
byte n1[8],n1b[8],n2[8],n2b[8],n3[8],n3b[8],n4[8],n4b[8],n5[8],n5b[8],n6[8],n6b[8],n7[8],n7b[8],n8[8],n8b[8],n9[8],n9b[8],n0[8],n0b[8];
int randomlevel,random2,random3,random4,random5;

void setup() {
  gamer.begin();
  //make a map!
  level[0]=B01010001;
  level[1]=B00010100;
  level[2]=B00000110;
  level[3]=B11010000;
  level[4]=B00001011;
  level[5]=B01100000;
  level[6]=B00101010;
  level[7]=B10001000;
  gamer.printImage(level);
  randomSeed(analogRead(0));
  setupNums();
}

void loop() {
  
  gamer.display[posX][posY]=LOW;
  gamer.display[ghostX][ghostY]=LOW;
  if(gamer.isPressed(UP) && !gamer.display[posX][posY-1]) dir=4;
  if(gamer.isPressed(RIGHT) && !gamer.display[posX+1][posY]) dir=1;
  if(gamer.isPressed(DOWN) && !gamer.display[posX][posY+1]) dir=2;
  if(gamer.isPressed(LEFT) && !gamer.display[posX-1][posY]) dir=3;
  if(dir==1 && !gamer.display[posX+1][posY]) incrementScore(1);
  if(dir==2 && !gamer.display[posX][posY+1]) incrementScore(2);
  if(dir==3 && !gamer.display[posX-1][posY]) incrementScore(3);
  if(dir==4 && !gamer.display[posX][posY-1]) incrementScore(4);
  if(posY>7) posY=7;
  if(posY<0) posY=0;
  if(posX>7) posX=7;
  if(posX<0) posX=0;
  //now for the ghost AI
  int testDirs[4];
  if(ghostX-posX>=0) {
    if(ghostY-posY>=0) {
      random2 = random(0,2);
      Serial.println(random2);
      
      if(random2==1) {
        testDirs[0]=4;
        testDirs[1]=3;
        testDirs[2]=2;
        testDirs[3]=1;
      } else {
        testDirs[0]=3;
        testDirs[1]=4;
        testDirs[2]=1;
        testDirs[3]=2;
      }
    } else {
      random3 = random(0,2);
      Serial.println(random3);
      
      if(random3==1) {
        testDirs[0]=3;
        testDirs[1]=2;
        testDirs[2]=4;
        testDirs[3]=1;
      } else {
        testDirs[0]=2;
        testDirs[1]=3;
        testDirs[2]=1;
        testDirs[3]=4;
      }
    }
  } else {
    random4 = random(0,2);
      Serial.println(random4);
    
    if(ghostY-posY>=0) {
      if(random4==1) {
        testDirs[0]=4;
        testDirs[1]=1;
        testDirs[2]=2;
        testDirs[3]=3;
      } else {
        testDirs[0]=1;
        testDirs[1]=4;
        testDirs[2]=3;
        testDirs[3]=2;
      }
    } else {
      random5 = random(0,2);
      Serial.println(random5);
      
      if(random5==1) {
        testDirs[0]=1;
        testDirs[1]=2;
        testDirs[2]=3;
        testDirs[3]=4;
      } else {
        testDirs[0]=2;
        testDirs[1]=1;
        testDirs[2]=4;
        testDirs[3]=3;
      }
    }
  }
  for(int a=0;a<4;a++) {
    if(checkIfItsOK(testDirs[a])) {
      gdir=testDirs[a];
      break;
    }
  }
  if(gdir==1 && !gamer.display[ghostX+1][ghostY]) ghostX++;
  if(gdir==2 && !gamer.display[ghostX][ghostY+1]) ghostY++;
  if(gdir==3 && !gamer.display[ghostX-1][ghostY]) ghostX--;
  if(gdir==4 && !gamer.display[ghostX][ghostY-1]) ghostY--;
  if(gdir==1 && posX==ghostX+1 && posY==ghostY) { 
    gameOver();
    paclevel(); }
  if(gdir==2 && posX==ghostX && posY==ghostY+1) {
    gameOver();
    paclevel(); }
  if(gdir==3 && posX==ghostX-1 && posY==ghostY) {
    gameOver();
    paclevel(); }
  if(gdir==4 && posX==ghostX && posY==ghostY-1) {
    gameOver();
    paclevel(); }
  if(ghostY>7) ghostY=7;
  if(ghostY<0) ghostY=0;
  if(ghostX>7) ghostX=7;
  if(ghostX<0) ghostX=0;
  gamer.display[posX][posY]=HIGH;
  gamer.display[ghostX][ghostY]=HIGH;
  gamer.updateDisplay();
  delay(100);
}

void paclevel() {
  //make a map!
  level[0]=B01010001;
  level[1]=B00010100;
  level[2]=B00000110;
  level[3]=B11010000;
  level[4]=B00001011;
  level[5]=B01100000;
  level[6]=B00101010;
  level[7]=B10001000;
  
  //or two...
  level2[0]=B00100000;
  level2[1]=B00010010;
  level2[2]=B00000100;
  level2[3]=B11001100;
  level2[4]=B00001011;
  level2[5]=B11100010;
  level2[6]=B10001000;
  level2[7]=B10010000;
  
  //or three...
  level3[0]=B00100000;
  level3[1]=B10110110;
  level3[2]=B00000000;
  level3[3]=B01101101;
  level3[4]=B00001011;
  level3[5]=B11010010;
  level3[6]=B00000000;
  level3[7]=B01010100;
  
  //or four...
  level4[0]=B00010000;
  level4[1]=B01010110;
  level4[2]=B00000100;
  level4[3]=B10011100;
  level4[4]=B00010001;
  level4[5]=B01000100;
  level4[6]=B01100010;
  level4[7]=B00001000;
  
  level5[0]=B00101010;
  level5[1]=B00000000;
  level5[2]=B01010101;
  level5[3]=B00000000;
  level5[4]=B10101010;
  level5[5]=B00000000;
  level5[6]=B01010101;
  level5[7]=B00000000;

  //hey, six levels!
  level6[0]=B00001000;
  level6[1]=B11100010;
  level6[2]=B00001010;
  level6[3]=B01000010;
  level6[4]=B01001100;
  level6[5]=B00101001;
  level6[6]=B01000000;
  level6[7]=B00010110;
  
  randomlevel = random(6);
  Serial.println(randomlevel);
  
  if (randomlevel == 0)
    gamer.printImage(level);
  if (randomlevel == 1)
    gamer.printImage(level2);
  if (randomlevel == 2)
    gamer.printImage(level3);
  if (randomlevel == 3)
    gamer.printImage(level4);
  if (randomlevel == 4)
    gamer.printImage(level5);
  if (randomlevel == 5)
    gamer.printImage(level6);  
}

void gameOver() {
  if(score>=0 && score<100) { //normal people
    int dig2 = score % 10; 
    int dig1 = (score-(score%10))/10;
    showScore(dig1,dig2);
    delay(3000);
  }
  if(score>=100 && score<1000) {  //insane people
    int dig2 = score % 10;
    int dig1 = ((score-dig2) % 100) / 10;
    int dig3 = (score-(score % 100)) / 100;
    showScore(0,dig3);
    delay(1500);
    showScore(dig1,dig2);
    delay(1500);
  }
  if(score>=1000 && score<10000) {  //amazing people
    int dig2 = score % 10; 
    int dig1 = ((score-dig2) % 100) / 10;
    int dig3 = ((score-(score % 100)) / 100) % 10;
    int dig4 = (score-(score % 1000)) / 1000;
    showScore(dig4,dig3);
    delay(1500);
    showScore(dig1,dig2);
    delay(1500);
  }
 
  posX=0;
  posY=0;
  ghostX=7;
  ghostY=7;
  dir=1;
  gdir=3;
  score=0;
  gamer.printImage(level);
}

boolean checkIfItsOK(int dir) {
  if(dir==1 && !gamer.display[ghostX+1][ghostY]) return true;
  if(dir==2 && !gamer.display[ghostX][ghostY+1]) return true;
  if(dir==3 && !gamer.display[ghostX-1][ghostY]) return true;
  if(dir==4 && !gamer.display[ghostX][ghostY-1]) return true;
  return false;
}

void incrementScore(int dir) {
  if(dir==1) posX++;
  if(dir==2) posY++;
  if(dir==3) posX--;
  if(dir==4) posY--;
  score++;
}

void showScore(int dig1,int dig2) {
  byte result[8];
  for(int p=0;p<8;p++) {
    result[p]=numbers[dig1][0][p]^numbers[dig2][1][p];
  }
  gamer.printImage(result);
}

void setupNums() {
  n1[0] = B10000000;
  n1[1] = B10000000;
  n1[2] = B10000000;
  n1[3] = B10000000;
  n1[4] = B10000000;
  n1[5] = B10000000;
  n1[6] = B10000000;
  n1[7] = B10000000;

  n1b[0] = B00000100;
  n1b[1] = B00000100;
  n1b[2] = B00000100;
  n1b[3] = B00000100;
  n1b[4] = B00000100;
  n1b[5] = B00000100;
  n1b[6] = B00000100;
  n1b[7] = B00000100;

  n2[0] = B11100000;
  n2[1] = B00100000;
  n2[2] = B00100000;
  n2[3] = B11100000;
  n2[4] = B10000000;
  n2[5] = B10000000;
  n2[6] = B10000000;
  n2[7] = B11100000;

  n2b[0] = B00000111;
  n2b[1] = B00000001;
  n2b[2] = B00000001;
  n2b[3] = B00000111;
  n2b[4] = B00000100;
  n2b[5] = B00000100;
  n2b[6] = B00000100;
  n2b[7] = B00000111;

  n3[0] = B11100000;
  n3[1] = B00100000;
  n3[2] = B00100000;
  n3[3] = B01100000;
  n3[4] = B00100000;
  n3[5] = B00100000;
  n3[6] = B00100000;
  n3[7] = B11100000;

  n3b[0] = B00000111;
  n3b[1] = B00000001;
  n3b[2] = B00000001;
  n3b[3] = B00000011;
  n3b[4] = B00000001;
  n3b[5] = B00000001;
  n3b[6] = B00000001;
  n3b[7] = B00000111;

  n4[0] = B10100000;
  n4[1] = B10100000;
  n4[2] = B10100000;
  n4[3] = B11100000;
  n4[4] = B00100000;
  n4[5] = B00100000;
  n4[6] = B00100000;
  n4[7] = B00100000;

  n4b[0] = B00000101;
  n4b[1] = B00000101;
  n4b[2] = B00000101;
  n4b[3] = B00000111;
  n4b[4] = B00000001;
  n4b[5] = B00000001;
  n4b[6] = B00000001;
  n4b[7] = B00000001;

  n5[0] = B11100000;
  n5[1] = B10000000;
  n5[2] = B10000000;
  n5[3] = B11100000;
  n5[4] = B00100000;
  n5[5] = B00100000;
  n5[6] = B00100000;
  n5[7] = B11100000;

  n5b[0] = B00000111;
  n5b[1] = B00000100;
  n5b[2] = B00000100;
  n5b[3] = B00000111;
  n5b[4] = B00000001;
  n5b[5] = B00000001;
  n5b[6] = B00000001;
  n5b[7] = B00000111;

  n6[0] = B11100000;
  n6[1] = B10000000;
  n6[2] = B10000000;
  n6[3] = B11100000;
  n6[4] = B10100000;
  n6[5] = B10100000;
  n6[6] = B10100000;
  n6[7] = B11100000;

  n6b[0] = B00000111;
  n6b[1] = B00000100;
  n6b[2] = B00000100;
  n6b[3] = B00000111;
  n6b[4] = B00000101;
  n6b[5] = B00000101;
  n6b[6] = B00000101;
  n6b[7] = B00000111;

  n7[0] = B11100000;
  n7[1] = B00100000;
  n7[2] = B00100000;
  n7[3] = B00100000;
  n7[4] = B00100000;
  n7[5] = B00100000;
  n7[6] = B00100000;
  n7[7] = B00100000;

  n7b[0] = B00000111;
  n7b[1] = B00000001;
  n7b[2] = B00000001;
  n7b[3] = B00000001;
  n7b[4] = B00000001;
  n7b[5] = B00000001;
  n7b[6] = B00000001;
  n7b[7] = B00000001;

  n8[0] = B11100000;
  n8[1] = B10100000;
  n8[2] = B10100000;
  n8[3] = B11100000;
  n8[4] = B10100000;
  n8[5] = B10100000;
  n8[6] = B10100000;
  n8[7] = B11100000;

  n8b[0] = B00000111;
  n8b[1] = B00000101;
  n8b[2] = B00000101;
  n8b[3] = B00000111;
  n8b[4] = B00000101;
  n8b[5] = B00000101;
  n8b[6] = B00000101;
  n8b[7] = B00000111;

  n9[0] = B11100000;
  n9[1] = B10100000;
  n9[2] = B10100000;
  n9[3] = B11100000;
  n9[4] = B00100000;
  n9[5] = B00100000;
  n9[6] = B00100000;
  n9[7] = B11100000;

  n9b[0] = B00000111;
  n9b[1] = B00000101;
  n9b[2] = B00000101;
  n9b[3] = B00000111;
  n9b[4] = B00000001;
  n9b[5] = B00000001;
  n9b[6] = B00000001;
  n9b[7] = B00000111;

  n0[0] = B11100000;
  n0[1] = B10100000;
  n0[2] = B10100000;
  n0[3] = B10100000;
  n0[4] = B10100000;
  n0[5] = B10100000;
  n0[6] = B10100000;
  n0[7] = B11100000;

  n0b[0] = B00000111;
  n0b[1] = B00000101;
  n0b[2] = B00000101;
  n0b[3] = B00000101;
  n0b[4] = B00000101;
  n0b[5] = B00000101;
  n0b[6] = B00000101;
  n0b[7] = B00000111;

  for(int x=0;x<8;x++) {
    numbers[0][0][x] = n0[x];
    numbers[1][0][x] = n1[x];
    numbers[2][0][x] = n2[x];
    numbers[3][0][x] = n3[x];
    numbers[4][0][x] = n4[x];
    numbers[5][0][x] = n5[x];
    numbers[6][0][x] = n6[x];
    numbers[7][0][x] = n7[x];
    numbers[8][0][x] = n8[x];
    numbers[9][0][x] = n9[x];
    numbers[0][1][x] = n0b[x];
    numbers[1][1][x] = n1b[x];
    numbers[2][1][x] = n2b[x];
    numbers[3][1][x] = n3b[x];
    numbers[4][1][x] = n4b[x];
    numbers[5][1][x] = n5b[x];
    numbers[6][1][x] = n6b[x];
    numbers[7][1][x] = n7b[x];
    numbers[8][1][x] = n8b[x];
    numbers[9][1][x] = n9b[x];
  }
}
