unit mScrabble1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, jpeg, ExtCtrls;

type
  TScrabble1 = class(TForm)
    BStart: TButton;
    BBuchstaben: TButton;
    BSpeichern: TButton;
    BLaden: TButton;
    Bclose: TButton;
    IMGscrabble: TImage;
    IMGSpielfeld: TImage;
    IMGhg: TImage;
    procedure BStartClick(Sender: TObject);
    procedure BcloseClick(Sender: TObject);
    procedure SpielsteinMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SpielsteinMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SpielsteinMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure BSpeichernClick(Sender: TObject);
    procedure BLadenClick(Sender: TObject);
    procedure BBuchstabenClick(Sender: TObject);
  private
    { Private-Deklarationen }
    mausgedrueckt: boolean;
    xstart, ystart: integer;
  public
    { Public-Deklarationen }
  end;

  type
   TSpielstein = class (TButton)
   constructor create (AOwner: TComponent); override;
end;

var
  Scrabble1: TScrabble1;
  Spielstein: array[1..20] of TSpielstein;

implementation

constructor TSpielstein.create(AOwner: TComponent);
begin
  inherited create(AOwner);
end;
{$R *.DFM}

procedure TScrabble1.SpielsteinMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Mausgedrueckt := true;
  xstart := x;
  ystart := y
end;

procedure TScrabble1.SpielsteinMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if mausgedrueckt and (sender is TSpielstein) then begin
    TSpielstein(Sender).Left:=TSpielstein(Sender).Left+(X-XStart);
    TSpielstein(Sender).Top:=TSpielstein(Sender).Top+(Y-XStart);
  end;
end;

procedure TScrabble1.SpielsteinMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Mausgedrueckt:= false;
end;

procedure TScrabble1.BStartClick(Sender: TObject);
var i, a, Buchstabe: integer;
begin
for a:=ComponentCount-1 downto 0 do
  begin
    if Components[a] is TSpielstein then
      Components[a].destroy;
 end;
  randomize;
 for i:=1 to 20 do
  begin
    Spielstein[i]:= TSpielstein.create(Scrabble1);
    with Spielstein[i] do begin
      Buchstabe:= random(25)+1;
      case Buchstabe of
        1: Caption:='A';
        2: Caption:='B';
        3: Caption:='C';
        4: Caption:='D';
        5: Caption:='E';
        6: Caption:='F';
        7: Caption:='G';
        8: Caption:='H';
        9: Caption:='I';
        10: Caption:='J';
        11: Caption:='K';
        12: Caption:='L';
        13: Caption:='M';
        14: Caption:='N';
        15: Caption:='O';
        16: Caption:='P';
        17: Caption:='Q';
        18: Caption:='R';
        19: Caption:='S';
        20: Caption:='T';
        21: Caption:='U';
        22: Caption:='V';
        23: Caption:='W';
        24: Caption:='X';
        25: Caption:='Y';
        26: Caption:='Z';
      end;
      height:=30;
      width:=30;
      Parent := Scrabble1;
      Left := i*30;
      Top := 30;
      OnMouseDown:=SpielsteinMouseDown;
      OnMouseUp:=SpielsteinMouseUp;
      OnMouseMove:=SpielsteinMouseMove;
    end;
  end;
end;

procedure TScrabble1.BcloseClick(Sender: TObject);
begin
 close;
end;

procedure TScrabble1.BSpeichernClick(Sender: TObject);
 var FileStream: TFilestream;
     I: Integer;
begin
 FileStream:= TFilestream.Create ('Scrabble.dat',fmCreate);
  for I := 0 to ComponentCount-1 do
   if Components[I] is TSpielstein then
      Filestream.WriteCOmponent(Components[I]);
      FileStream.Destroy;
end;

procedure TScrabble1.BLadenClick(Sender: TObject);
 var FileStream: TFilestream;
     I,a: Integer;
begin
 for I := ComponentCount-1 downto 0 do
 if Components[I] is TSpielstein
   then Components[I].Destroy;
    FileStream := TFileStream.Create ('Scrabble.dat',fmOpenRead);
    for a:= 1 to 20 do
begin
  while FileStream.Position < FileStream.Size
   do begin
    Spielstein[a]:= TSpielstein.create(Scrabble1);
    FileStream.ReadComponent(Components[ComponentCount-1]);
    Spielstein[a].OnMouseDown := SpielsteinMouseDown;
    Spielstein[a].OnMouseUp := SpielsteinMouseUp;
    Spielstein[a].OnMouseMove := SpielsteinMouseMove;
    Spielstein[a].Parent := Scrabble1;
   end;
  end;
   FileStream.Destroy;
end;

procedure TScrabble1.BBuchstabenClick(Sender: TObject);
var i, a, Buchstabe: integer;
begin
for a:=ComponentCount-1 downto 0 do
  randomize;
  for i:=1 to 20 do
  begin
    Spielstein[i]:= TSpielstein.create(Scrabble1);
    with Spielstein[i] do begin
      Buchstabe:= random(25)+1;
      case Buchstabe of
        1: Caption:='A';
        2: Caption:='B';
        3: Caption:='C';
        4: Caption:='D';
        5: Caption:='E';
        6: Caption:='F';
        7: Caption:='G';
        8: Caption:='H';
        9: Caption:='I';
        10: Caption:='J';
        11: Caption:='K';
        12: Caption:='L';
        13: Caption:='M';
        14: Caption:='N';
        15: Caption:='O';
        16: Caption:='P';
        17: Caption:='Q';
        18: Caption:='R';
        19: Caption:='S';
        20: Caption:='T';
        21: Caption:='U';
        22: Caption:='V';
        23: Caption:='W';
        24: Caption:='X';
        25: Caption:='Y';
        26: Caption:='Z';
      end;
      height:=30;
      width:=30;
      Parent := Scrabble1;
      Left := i*30;
      Top := 30;
      OnMouseDown:=SpielsteinMouseDown;
      OnMouseUp:=SpielsteinMouseUp;
      OnMouseMove:=SpielsteinMouseMove;
    end;
  end;
end;

end.
