#ifndef STRUCTS_H
#define STRUCTS_H

#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#include "SDL/SDL_ttf.h"
#include <fstream>
#include <string>
#include <sstream>
#include <time.h>
#include <iostream>

using namespace std;

const int SCREEN_WIDTH = 800;
const int SCREEN_HEIGHT = 600;
const int SCREEN_BPP = 32;

const int TILESIZE = 32;
const int NUMTILES = 7;
const int NUMLIGHT = 5;
const int NUMLEVELS = 50;
const int NUMCUSTOM = 5;
const int LANTERNSIZE = 5;
const int LIGHTSIZE = 7;
const int CHARWIDTH = 6;
const int CHARHEIGHT = 2;
const int INVITEMS = 4;
const int LVLITEMS = 7;
const int MIDSCREEN = 128;
const int SPEED = 7;
const int MAXMAPSIZE = 50;

const int SPACE = 0;
const int PSPACE = 1;
const int WALL = 2;
const int PWALL = 3;
const int TRAPWALL = 4;

const int LANTERN = 0;
const int INVISPOT = 1;
const int KEY = 2;
const int BOOTS = 3;

const int SWITCH = 0;
const int CHEST = 1;
const int DOOR = 2;
const int LOCKDOOR = 3;
const int LIGHTSRC = 4;
const int LASER = 5;
const int GEM = 6;

const int DOWN = 0;
const int UP = 1;
const int LEFT = 2;
const int RIGHT = 3;
const int INVIS = 4;
const int SPECIAL = 5;

const int POWERON = 1;

SDL_Surface *loadImage(string file);
void blitImage(int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip = NULL);
string iToS(int x);

struct Location{
	int x;
	int y;
};

struct Tile{
	Location loc;
	int tile;
	int light;
	int laserH;
	int laserV;
	int chest; //corresponding item # in the chest (set to -1 for open)
	bool item[LVLITEMS];
	bool traversable;
	bool unlocked;
	bool power;
};

//nodes used in the stack to point to their tile and the next node
struct Node{
	Node *next;
	Tile *t;
};

#endif
