#include "menu.h"

Button::Button(string file, int x0, int y0, int x1, int y1){
	image = loadImage(file.c_str());
	origin.x = x0;
	origin.y = y0;
	to.x = x1;
	to.y = y1;
}

Button::~Button(){
	SDL_FreeSurface(image);
}

void Button::blit(SDL_Surface *screen){
	int xErr = (screen->w / 2) - (SCREEN_WIDTH / 2);
	int yErr = (screen->h / 2) - (SCREEN_HEIGHT / 2);
	blitImage(xErr + origin.x, yErr + origin.y, image, screen);
}

void Button::check(int x, int y, bool &flip, SDL_Surface *screen){
	int xErr = (screen->w / 2) - (SCREEN_WIDTH / 2);
	int yErr = (screen->h / 2) - (SCREEN_HEIGHT / 2);
	if(x > origin.x + xErr && y > origin.y + yErr && x < to.x + xErr && y < to.y + yErr)
		flip = !flip;
}

void Button::checkAdd(int x, int y, int &level, int change, SDL_Surface *screen){
	int xErr = (screen->w / 2) - (SCREEN_WIDTH / 2);
	int yErr = (screen->h / 2) - (SCREEN_HEIGHT / 2);
	if(x > origin.x + xErr && y > origin.y + yErr && x < to.x + xErr && y < to.y + yErr)
		level += change;
}
