/*
Sneak Thief
Made by: Anthony Tesija
Start December 2011 - End February 2012
*/

#include "game.h"
#include "editor.h"
#include "menu.h"

//Have you collected the gem for a specific level?
//This came in way late, that's why it's a global  // <-- Ignore that From now on I'll be using globals in games...
bool gems[NUMLEVELS];
bool customs[NUMCUSTOM];
//Number of gems collected
int collected = 0;
//The font and color (black)
TTF_Font *font = NULL;
TTF_Font *largeFont = NULL;
SDL_Color black = {0, 0, 0};

void resize(SDL_Surface *screen, SDL_Event &event){
	if(event.resize.w < SCREEN_WIDTH || event.resize.h < SCREEN_HEIGHT)
		screen = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE | SDL_RESIZABLE);
	else
		screen = SDL_SetVideoMode(event.resize.w, event.resize.h, SCREEN_BPP, SDL_SWSURFACE | SDL_RESIZABLE);
}

int game(bool &quit, SDL_Event &event, SDL_Surface *screen, int level){
	bool win = false, dead = false, end = false;
	while(!quit && !end){
		string file = "mainlevels/main";
		file += iToS(level);
		file += ".lvl";
		Map map(file);
		int startTime = SDL_GetTicks();
		int timer;
		while(!quit && !win && !dead && !end){
			timer = SDL_GetTicks();
			while(SDL_PollEvent(&event)){
				if(event.type == SDL_QUIT)
					quit = true;
				else if(event.type == SDL_VIDEORESIZE)
					resize(screen, event);
				else
					end = map.handleEvent(event, win, dead, screen, startTime);
			}
			if(startTime < timer){
				map.checkDead(dead);
				map.heldMovement(win, dead, quit);
				map.blit(screen);
				SDL_Flip(screen);
				startTime += 50;
			}
		}
		if(win){
			map.blit(screen);
			map.blitWin(screen);
			win = false;
			if(!gems[level]){
				gems[level] = true;
				++collected;
			}
			++level;
		}
		else if(dead){
			map.blitDead(screen);
			dead = false;
		}
		map.clearMap();
		if(level == 50)
			end = true;
	}
}

void editor(bool &quit, SDL_Event &event, SDL_Surface *screen, int level){
	Editor editor(level);
	//if editing (existing level)
	if(customs[level])
		editor.edit();
	bool save = true, end = false;
	while(!quit && !end){
		while(SDL_PollEvent(&event)){
			if(event.type == SDL_QUIT)
				quit = true;
			else if(event.type == SDL_VIDEORESIZE)
				resize(screen, event);
			else
				editor.handleEvent(screen, event, end, save);
		}
		editor.blit(screen);
		SDL_Flip(screen);
	}
	editor.outputLevel();
	customs[level] = true;
}

void playCustom(bool &quit, SDL_Event &event, SDL_Surface *screen, int level){
	bool win = false, dead = false, end = false;
	while(!quit && !end){
		string file = "customlevels/custom";
		file += iToS(level);
		file += ".lvl";
		Map map(file);
		int startTime = SDL_GetTicks();
		int timer;
		while(!quit && !win && !dead && !end){
			timer = SDL_GetTicks();
			while(SDL_PollEvent(&event)){
				if(event.type == SDL_QUIT)
					quit = true;
				else if(event.type == SDL_VIDEORESIZE)
					resize(screen, event);
				else
					end = map.handleEvent(event, win, dead, screen, startTime);
			}
			if(startTime < timer){
				map.checkDead(dead);
				map.heldMovement(win, dead, quit);
				map.blit(screen);
				SDL_Flip(screen);
				startTime += 50;
			}
		}
		if(win){
			map.blit(screen);
			map.blitWin(screen);
			win = false;
			end = true;
		}
		else if(dead){
			map.blitDead(screen);
			dead = false;
			end = true;
		}
		map.clearMap();
	}
}

void customSelect(bool &quit, SDL_Event &event, SDL_Surface *screen, SDL_Surface *menubg){
	int level = 0;
	bool end = false, play = false, edit = false, del = false, start = false;
	string text, file;
	SDL_Surface *message = NULL;
	Button haveGem("images/havegem.png", 350, 25, 350, 25);
	Button noGem("images/nogem.png", 350, 25, 350, 25);
	Button next("images/nextlvl.png", 600, 175, 750, 375);
	Button prev("images/prevlvl.png", 50, 175, 200, 375);
	Button back("images/back.png", 700, 50, 750, 100);
	Button doit("images/custom.png", 250, 125, 550, 425);
	Button playB("images/play.png", 50, 450, 250, 550);
	Button editB("images/edit.png", 300, 450, 500, 550);
	Button delB("images/delete.png", 550, 450, 750, 550);
	while(!quit && !end){
		while(SDL_PollEvent(&event)){
			if(event.type == SDL_QUIT)
				quit = true;
			else if(event.type == SDL_VIDEORESIZE)
				resize(screen, event);
			else if(event.type == SDL_KEYDOWN && event.key.keysym.sym == SDLK_ESCAPE)
				end = true;
			else if(event.type == SDL_MOUSEBUTTONDOWN)
				if(event.button.button == SDL_BUTTON_LEFT){
					next.checkAdd(event.button.x, event.button.y, level, 1, screen);
					prev.checkAdd(event.button.x, event.button.y, level, -1, screen);
					back.check(event.button.x, event.button.y, end, screen);
					doit.check(event.button.x, event.button.y, start, screen);
					playB.check(event.button.x, event.button.y, play, screen);
					editB.check(event.button.x, event.button.y, edit, screen);
					delB.check(event.button.x, event.button.y, del, screen);
					if(level < 0)
						level += NUMCUSTOM;
					if(level >= NUMCUSTOM)
						level -= NUMCUSTOM;
				}
		}
		//blit background
		for(int i = 0; i < screen->w; i += 100)
			for(int j = 0; j < screen->h; j += 100)
				blitImage(i, j, menubg, screen);
		//blit buttons
		next.blit(screen);
		prev.blit(screen);
		back.blit(screen);
		doit.blit(screen);
		playB.blit(screen);
		editB.blit(screen);
		delB.blit(screen);
		//blit text surface
		text = iToS(level + 1);
		message = TTF_RenderText_Solid(largeFont, text.c_str(), black);
		blitImage((screen->w / 2) - 20, (screen->h / 2) - 80, message, screen);
		SDL_FreeSurface(message);
		if(customs[level])
			haveGem.blit(screen);
		else
			noGem.blit(screen);
		SDL_Flip(screen);
		if(edit){
			editor(quit, event, screen, level);
			edit = false;
		}
		else if(del){
			file = "customlevels/custom";
			file += iToS(level);
			file += ".lvl";
			ofstream out(file.c_str());
			out.close();
			customs[level] = false;
			del = false;
		}
		else if(play && customs[level]){
			playCustom(quit, event, screen, level);
			play = false;
		}
	}
}

void levelSelect(bool &quit, SDL_Event &event, SDL_Surface *screen, SDL_Surface *menubg){
	bool end = false, playGame = false;;
	int level = 0;
	string text;
	SDL_Surface *message = NULL;
	Button haveGem("images/havegem.png", 350, 25, 350, 25);
	Button noGem("images/nogem.png", 350, 25, 350, 25);
	Button levelbg("images/levelbg.png", 250, 150, 550, 450);
	Button next("images/nextlvl.png", 600, 200, 750, 400);
	Button prev("images/prevlvl.png", 50, 200, 200, 400);
	Button back("images/back.png", 700, 50, 750, 100);
	Button next10("images/next10.png", 550, 450, 750, 550);
	Button prev10("images/prev10.png", 50, 450, 250, 550);
	while(!quit && !end){
		while(SDL_PollEvent(&event)){
			if(event.type == SDL_QUIT)
				quit = true;
			else if(event.type == SDL_VIDEORESIZE)
				resize(screen, event);
			else if(event.type == SDL_KEYDOWN && event.key.keysym.sym == SDLK_ESCAPE)
				end = true;
			else if(event.type == SDL_MOUSEBUTTONDOWN)
				if(event.button.button == SDL_BUTTON_LEFT){
					levelbg.check(event.button.x, event.button.y, playGame, screen);
					next.checkAdd(event.button.x, event.button.y, level, 1, screen);
					prev.checkAdd(event.button.x, event.button.y, level, -1, screen);
					back.check(event.button.x, event.button.y, end, screen);
					next10.checkAdd(event.button.x, event.button.y, level, 10, screen);
					prev10.checkAdd(event.button.x, event.button.y, level, -10, screen);
					if(level < 0)
						level += NUMLEVELS;
					if(level >= NUMLEVELS)
						level -= NUMLEVELS;
				}
		}
		//blit background
		for(int i = 0; i < screen->w; i += 100)
			for(int j = 0; j < screen->h; j += 100)
				blitImage(i, j, menubg, screen);
		//blit buttons
		levelbg.blit(screen);
		next.blit(screen);
		prev.blit(screen);
		back.blit(screen);
		next10.blit(screen);
		prev10.blit(screen);
		//blit text surface
		text = iToS(collected) + " / 50";
		message = TTF_RenderText_Solid(font, text.c_str(), black);
		blitImage(50, 25, message, screen);
		SDL_FreeSurface(message);
		if(level < 9)
			text = "0" + iToS(level + 1);
		else
			text = iToS(level + 1);
		message = TTF_RenderText_Solid(largeFont, text.c_str(), black);
		blitImage((screen->w / 2) - 50, (screen->h / 2) - 30, message, screen);
		SDL_FreeSurface(message);
		if(gems[level])
			haveGem.blit(screen);
		else
			noGem.blit(screen);
		SDL_Flip(screen);
		if(playGame){
			game(quit, event, screen, level);
			playGame = false;
			end = true;
		}
	}
}

void controlScreen(bool &quit, SDL_Event &event, SDL_Surface *screen, SDL_Surface *menubg){
	int disp = 0;
	Button controls("images/controls.png", 0, 0, 800, 600);
	Button controls2("images/controls2.png", 0, 0, 800, 600);
	while(!quit && disp < 2){
		while(SDL_PollEvent(&event)){
			if(event.type == SDL_QUIT)
				quit = true;
			else if(event.type == SDL_VIDEORESIZE)
				resize(screen, event);
			else if(event.type == SDL_KEYDOWN){
				switch(event.key.keysym.sym){
					case SDLK_ESCAPE: quit = true; break;
				}
			}
			//check if a button was clicked
			else if(event.type == SDL_MOUSEBUTTONDOWN)
				if(event.button.button == SDL_BUTTON_LEFT)
					controls.checkAdd(event.button.x, event.button.y, disp, 1, screen);
		}
		//blit background and buttons
		for(int i = 0; i < screen->w; i += 100)
			for(int j = 0; j < screen->h; j += 100)
				blitImage(i, j, menubg, screen);
		if(disp == 0)
			controls.blit(screen);
		else
			controls2.blit(screen);
		SDL_Flip(screen);
	}
}

void intro(bool &quit, SDL_Event &event, SDL_Surface *screen, SDL_Surface *menubg){
	int disp = 0;
	bool first = 0;
	ifstream in("data/first.info");
	in >> first;
	in.close();
	Button controls("images/GCHlogo.png", 0, 0, 800, 600);
	Button controls2("images/intro.png", 0, 0, 800, 600);
	while(!quit && disp < 2){
		while(SDL_PollEvent(&event)){
			if(event.type == SDL_QUIT)
				quit = true;
			else if(event.type == SDL_VIDEORESIZE)
				resize(screen, event);
			else if(event.type == SDL_KEYDOWN){
				if(event.key.keysym.sym == SDLK_ESCAPE)
					quit = true;
				else
					++disp;
			}
			//check if a button was clicked
			else if(event.type == SDL_MOUSEBUTTONDOWN)
				if(event.button.button == SDL_BUTTON_LEFT)
					controls.checkAdd(event.button.x, event.button.y, disp, 1, screen);
		}
		if(!first && disp == 1)
			++disp;
		//blit background and buttons
		for(int i = 0; i < screen->w; i += 100)
			for(int j = 0; j < screen->h; j += 100)
				blitImage(i, j, menubg, screen);
		if(disp == 0)
			controls.blit(screen);
		else if(disp == 1)
			controls2.blit(screen);
		SDL_Flip(screen);
	}
	ofstream out("data/first.info");
	out << 0;
	out.close();
}

int main(int argc, char *argv[]){
	//initialize rand and SDL
	srand(time(NULL));
	SDL_Init(SDL_INIT_EVERYTHING);
	TTF_Init();
	SDL_Surface *icon = SDL_LoadBMP("images/icon.bmp");
	SDL_WM_SetIcon(icon, NULL);
	SDL_Surface *screen = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE | SDL_RESIZABLE);
	SDL_WM_SetCaption("Sneak Thief", NULL);
	bool quit = false;
	bool loadGame = false, loadEditor = false, loadControl = false;
	SDL_Event event;
	//Load the font
	font = TTF_OpenFont("fonts/minimum.ttf", 70);
	largeFont = TTF_OpenFont("fonts/minimum.ttf", 110);
	//Load menu images
	SDL_Surface *menubg = loadImage("images/menubg.png");
	//Load menu buttons
	Button gameButton("images/playbutton.png", 50, 50, 375, 350);
	Button editorButton("images/custombutton.png", 425, 50, 750, 350);
	Button controlButton("images/controlbutton.png", 50, 400, 750, 550);
	//load the gems collected
	char junk;
	ifstream in("data/gem.info");
	for(int i = 0; i < NUMLEVELS; ++i)
		in >> gems[i] >> junk; 
	in >> collected;
	in.close();
	in.open("data/custom.info");
	for(int i = 0; i < NUMCUSTOM; ++i)
		in >> customs[i] >> junk;
	in.close();
	intro(quit, event, screen, menubg);
	while(!quit){
		while(SDL_PollEvent(&event)){
			if(event.type == SDL_QUIT)
				quit = true;
			else if(event.type == SDL_VIDEORESIZE)
				resize(screen, event);
			else if(event.type == SDL_KEYDOWN){
				switch(event.key.keysym.sym){
					case SDLK_ESCAPE: quit = true; break;
				}
			}
			//check if a button was clicked
			else if(event.type == SDL_MOUSEBUTTONDOWN)
				if(event.button.button == SDL_BUTTON_LEFT){
					gameButton.check(event.button.x, event.button.y, loadGame, screen);
					editorButton.check(event.button.x, event.button.y, loadEditor, screen);
					controlButton.check(event.button.x, event.button.y, loadControl, screen);
				}
		}
		//blit background and buttons
		for(int i = 0; i < screen->w; i += 100)
			for(int j = 0; j < screen->h; j += 100)
				blitImage(i, j, menubg, screen);
		gameButton.blit(screen);
		editorButton.blit(screen);
		controlButton.blit(screen);
		SDL_Flip(screen);
		//If something was clicked, go there
		if(loadGame){
			levelSelect(quit, event, screen, menubg);
			loadGame = false;
		}
		else if(loadEditor){
			customSelect(quit, event, screen, menubg);
			loadEditor = false;
		}
		else if(loadControl){
			controlScreen(quit, event, screen, menubg);
			loadControl = false;
		}
	}
	ofstream out("data/gem.info");
	for(int i = 0; i < NUMLEVELS; ++i){
		if(gems[i])
			out << '1';
		else
			out << '0';
		out << ';';
	}
	out << collected;
	out.close();
	out.open("data/custom.info");
	for(int i = 0; i < NUMCUSTOM; ++i){
		if(customs[i])
			out << '1';
		else
			out << '0';
		out << ';';
	}
	out.close();
	TTF_CloseFont(font);
	TTF_CloseFont(largeFont);
	TTF_Quit();
	SDL_FreeSurface(menubg);
	SDL_FreeSurface(icon);
	SDL_Quit();
	return 0;
}
