#include "structs.h"

class Player{
public:
	Location at;
	Location to;
	SDL_Surface *player;
	SDL_Rect sprite[CHARHEIGHT][CHARWIDTH];
	int direction;
	int frame; //which frame of the sprite to blit (0 or 1)
	int speed; //not sure if I need this yet
	int anim;
	bool moving;
	bool invisible;
	bool inventory[INVITEMS];
	bool held; //holding down the key for continuous movement

	Player();
	~Player();
	void blit(SDL_Surface *screen);
	bool handleEvent(SDL_Event &event);
	void move(int dir);
	void translate();
};

class Stack{
	Node *top;
public:
	Stack();
	~Stack();
	bool isEmpty();
	void insert(Tile *t);
	Tile *remove();
};

class Map{
	Player player;
	Stack powerStack;
	SDL_Surface *terrain;
	SDL_Surface *lvlitems;
	SDL_Surface *items;
	SDL_Surface *other;
	SDL_Surface *background;
	SDL_Surface *hud;
	SDL_Rect sprite[NUMLIGHT][NUMTILES];
	Location mapSize;
	Location pLoc;
	Tile tile[MAXMAPSIZE][MAXMAPSIZE];
	int lightsrc[LIGHTSIZE][LIGHTSIZE];
	int lantern[LANTERNSIZE][LANTERNSIZE];
	int anim;
	int frame;

	Map();
public:
	Map(string file);
	~Map();
	void blit(SDL_Surface *screen);
	void blitWin(SDL_Surface *screen);
	void blitDead(SDL_Surface *screen);
	void blitItem(SDL_Surface *screen, int item, int &timer);
	void clearMap();
	bool handleEvent(SDL_Event &event, bool &win, bool &dead, SDL_Surface *screen, int &timer);
	void heldMovement(bool &win, bool &dead, bool &quit);
	void checkTile(bool &dead);
	void checkDead(bool &dead);
	bool canMove(int dir);
	void action(bool &win, SDL_Surface *screen, int &timer);
	bool inbounds(int x, int y);
	void lamp(bool light);
	void power(int x, int y);
	void light(int x, int y);
	void laser(int x, int y);
	void door(int x, int y);
};
