/* Fang das Licht 0.1 für DIY Gamer Kit V1
  /e Catch the Light

v0.1
---
Funktionen:
links, rechts, vorne, unten = Bewegen
/e left, right, up, down = Move

Start: links oben.
/e Start: top left.

Mit Highscore!
/e With HighScore!

Neustart_ Resetknopf beim Arduino drücken
/e Restart: Resetbutton on Arduino

...Fang das Licht!
/e ...Catch the Light!

Autor: Tobi(as Apfelbaum)
Web: http://www.topfree.de/thema/spielereien/diy-gamer-kit */

#include <Gamer.h>
#include <EEPROM.h>

Gamer gamer;

int richtung;
int aktuelle_positionX = 0;
int aktuelle_positionY = 0;
int lichtpunktX;
int lichtpunktY;
long zufall, zufall2;
int punkte = 0;
int highscore;
int dig1, dig2;
unsigned long timercount = 0;
unsigned long timer_start = 0;
unsigned long wartezeit = 1500; //höher stellen, wenn //delay auskommentiert
unsigned long spielzeit = 0;
unsigned long spiel_start = 0;
unsigned long spielzeit_gesamt = 60000; //in ms

byte top[8] = {
B11101110,
B01001010,
B01001110,
B00000000,
B00111000,
B00101000,
B00111000,
B00100000};

byte numbers[10][2][8];
byte n1[8],n1b[8],n2[8],n2b[8],n3[8],n3b[8],n4[8],n4b[8],n5[8],n5b[8],n6[8],n6b[8],n7[8],n7b[8],n8[8],n8b[8],n9[8],n9b[8],n0[8],n0b[8];

void setup() {
 randomSeed(analogRead(0));
 timer_start = millis();
 spiel_start = millis();
 gamer.begin();
 gamer.display[0][0] = HIGH;
 gamer.updateDisplay();
 setupScore();
 zufall = random(8);
 Serial.println(zufall);
 zufall2 = random (8);
 Serial.println(zufall2);
 lichtpunktX = zufall;
 lichtpunktY = zufall2;
 }

void loop() {
    spielzeit = millis();
    if (spielzeit - spiel_start < spielzeit_gesamt){
    zufall = random(8);
    Serial.println(zufall);
    zufall2 = random (8);
    Serial.println(zufall2);
    timercount = millis();
    steuerung();
    }
    else {
     dig2 = punkte % 10;  //split score into two digits (eg 10 -> 1 and 0)
     dig1 = (punkte-(punkte%10))/10;
     showScore(dig1,dig2);
     delay(5000);
     gamer.printImage(top);
     delay(2000);
     highscore = EEPROM.read(1);
     if (punkte > highscore) {
       highscore = punkte;
       EEPROM.write(1, highscore);
     }
     dig2 = highscore % 10;  //split score into two digits (eg 10 -> 1 and 0)
     dig1 = (highscore-(highscore%10))/10;
     showScore(dig1,dig2);
     delay(5000);
     gamer.clear();
     delay(1000);
  } 
}
void steuerung () {
  
  for(int x=0;x<8;x++) {
    for(int y=0;y<8;y++) {
      gamer.display[x][y] = LOW;
    }
  }
  
  if(gamer.isPressed(UP)) richtung=1;
  if(gamer.isPressed(RIGHT)) richtung=2;
  if(gamer.isPressed(DOWN)) richtung=3;
  if(gamer.isPressed(LEFT)) richtung=4;
  
  if(richtung==1) {
    aktuelle_positionY--;
    if(aktuelle_positionY<0) aktuelle_positionY=0;
    richtung = 0;
  } else if(richtung==2) {
    aktuelle_positionX++;
    if(aktuelle_positionX>7) aktuelle_positionX=7;
    richtung = 0;
  } else if(richtung==3) {
    aktuelle_positionY++;
    if(aktuelle_positionY>7) aktuelle_positionY=7;
    richtung = 0;
  } else if(richtung==4) {
    aktuelle_positionX--;
    if(aktuelle_positionX<0) aktuelle_positionX=0;
    richtung = 0;
  }
  gamer.display[aktuelle_positionX][aktuelle_positionY] = HIGH;
  licht();
  // delay(150); // Eigener Pixel Geschwindigkeit: auskommentiert = langsamer (in ms)
  gamer.updateDisplay();
}

void licht() {
  
  if (timercount - timer_start < wartezeit){
  if(aktuelle_positionX == lichtpunktX && aktuelle_positionY == lichtpunktY) {
    punkte++;
    gamer.setLED(HIGH);
    delay(100);
    gamer.setLED(LOW);
    lichtpunktX = zufall;
    lichtpunktY = zufall2;
        if(aktuelle_positionX == lichtpunktX && aktuelle_positionY == lichtpunktY) {
     zufall = random(8);
     Serial.println(zufall);
     zufall2 = random (8);
     Serial.println(zufall2);
     lichtpunktX = zufall2;
     lichtpunktY = zufall;
 }
    delay(150);

    timer_start = timercount;
  }
    else {
    gamer.display[lichtpunktX][lichtpunktY] = HIGH;
    delay(150);
    if(aktuelle_positionX == lichtpunktX && aktuelle_positionY == lichtpunktY) {
    zufall = random(8);
    Serial.println(zufall);
    zufall2 = random (8);
    Serial.println(zufall2);
    lichtpunktX = zufall2;
    lichtpunktY = zufall;
 }
      }
    }
  else {
    lichtpunktX = zufall;
    lichtpunktY = zufall2;
    
    if(aktuelle_positionX == lichtpunktX && aktuelle_positionY == lichtpunktY) {
     lichtpunktX = zufall2;
     lichtpunktY = zufall;
 }
    
    timer_start = timercount;
  }
  gamer.updateDisplay();
}

//HighScore
void setupScore() {
  n1[0] = B10000000;
  n1[1] = B10000000;
  n1[2] = B10000000;
  n1[3] = B10000000;
  n1[4] = B10000000;
  n1[5] = B10000000;
  n1[6] = B10000000;
  n1[7] = B10000000;

  n1b[0] = B00000100;
  n1b[1] = B00000100;
  n1b[2] = B00000100;
  n1b[3] = B00000100;
  n1b[4] = B00000100;
  n1b[5] = B00000100;
  n1b[6] = B00000100;
  n1b[7] = B00000100;

  n2[0] = B11100000;
  n2[1] = B00100000;
  n2[2] = B00100000;
  n2[3] = B11100000;
  n2[4] = B10000000;
  n2[5] = B10000000;
  n2[6] = B10000000;
  n2[7] = B11100000;

  n2b[0] = B00000111;
  n2b[1] = B00000001;
  n2b[2] = B00000001;
  n2b[3] = B00000111;
  n2b[4] = B00000100;
  n2b[5] = B00000100;
  n2b[6] = B00000100;
  n2b[7] = B00000111;

  n3[0] = B11100000;
  n3[1] = B00100000;
  n3[2] = B00100000;
  n3[3] = B01100000;
  n3[4] = B00100000;
  n3[5] = B00100000;
  n3[6] = B00100000;
  n3[7] = B11100000;

  n3b[0] = B00000111;
  n3b[1] = B00000001;
  n3b[2] = B00000001;
  n3b[3] = B00000011;
  n3b[4] = B00000001;
  n3b[5] = B00000001;
  n3b[6] = B00000001;
  n3b[7] = B00000111;

  n4[0] = B10100000;
  n4[1] = B10100000;
  n4[2] = B10100000;
  n4[3] = B11100000;
  n4[4] = B00100000;
  n4[5] = B00100000;
  n4[6] = B00100000;
  n4[7] = B00100000;

  n4b[0] = B00000101;
  n4b[1] = B00000101;
  n4b[2] = B00000101;
  n4b[3] = B00000111;
  n4b[4] = B00000001;
  n4b[5] = B00000001;
  n4b[6] = B00000001;
  n4b[7] = B00000001;

  n5[0] = B11100000;
  n5[1] = B10000000;
  n5[2] = B10000000;
  n5[3] = B11100000;
  n5[4] = B00100000;
  n5[5] = B00100000;
  n5[6] = B00100000;
  n5[7] = B11100000;

  n5b[0] = B00000111;
  n5b[1] = B00000100;
  n5b[2] = B00000100;
  n5b[3] = B00000111;
  n5b[4] = B00000001;
  n5b[5] = B00000001;
  n5b[6] = B00000001;
  n5b[7] = B00000111;

  n6[0] = B11100000;
  n6[1] = B10000000;
  n6[2] = B10000000;
  n6[3] = B11100000;
  n6[4] = B10100000;
  n6[5] = B10100000;
  n6[6] = B10100000;
  n6[7] = B11100000;

  n6b[0] = B00000111;
  n6b[1] = B00000100;
  n6b[2] = B00000100;
  n6b[3] = B00000111;
  n6b[4] = B00000101;
  n6b[5] = B00000101;
  n6b[6] = B00000101;
  n6b[7] = B00000111;

  n7[0] = B11100000;
  n7[1] = B00100000;
  n7[2] = B00100000;
  n7[3] = B00100000;
  n7[4] = B00100000;
  n7[5] = B00100000;
  n7[6] = B00100000;
  n7[7] = B00100000;

  n7b[0] = B00000111;
  n7b[1] = B00000001;
  n7b[2] = B00000001;
  n7b[3] = B00000001;
  n7b[4] = B00000001;
  n7b[5] = B00000001;
  n7b[6] = B00000001;
  n7b[7] = B00000001;

  n8[0] = B11100000;
  n8[1] = B10100000;
  n8[2] = B10100000;
  n8[3] = B11100000;
  n8[4] = B10100000;
  n8[5] = B10100000;
  n8[6] = B10100000;
  n8[7] = B11100000;

  n8b[0] = B00000111;
  n8b[1] = B00000101;
  n8b[2] = B00000101;
  n8b[3] = B00000111;
  n8b[4] = B00000101;
  n8b[5] = B00000101;
  n8b[6] = B00000101;
  n8b[7] = B00000111;

  n9[0] = B11100000;
  n9[1] = B10100000;
  n9[2] = B10100000;
  n9[3] = B11100000;
  n9[4] = B00100000;
  n9[5] = B00100000;
  n9[6] = B00100000;
  n9[7] = B11100000;

  n9b[0] = B00000111;
  n9b[1] = B00000101;
  n9b[2] = B00000101;
  n9b[3] = B00000111;
  n9b[4] = B00000001;
  n9b[5] = B00000001;
  n9b[6] = B00000001;
  n9b[7] = B00000111;

  n0[0] = B11100000;
  n0[1] = B10100000;
  n0[2] = B10100000;
  n0[3] = B10100000;
  n0[4] = B10100000;
  n0[5] = B10100000;
  n0[6] = B10100000;
  n0[7] = B11100000;

  n0b[0] = B00000111;
  n0b[1] = B00000101;
  n0b[2] = B00000101;
  n0b[3] = B00000101;
  n0b[4] = B00000101;
  n0b[5] = B00000101;
  n0b[6] = B00000101;
  n0b[7] = B00000111;

  for(int x=0;x<8;x++) {
    numbers[0][0][x] = n0[x];
    numbers[1][0][x] = n1[x];
    numbers[2][0][x] = n2[x];
    numbers[3][0][x] = n3[x];
    numbers[4][0][x] = n4[x];
    numbers[5][0][x] = n5[x];
    numbers[6][0][x] = n6[x];
    numbers[7][0][x] = n7[x];
    numbers[8][0][x] = n8[x];
    numbers[9][0][x] = n9[x];
    numbers[0][1][x] = n0b[x];
    numbers[1][1][x] = n1b[x];
    numbers[2][1][x] = n2b[x];
    numbers[3][1][x] = n3b[x];
    numbers[4][1][x] = n4b[x];
    numbers[5][1][x] = n5b[x];
    numbers[6][1][x] = n6b[x];
    numbers[7][1][x] = n7b[x];
    numbers[8][1][x] = n8b[x];
    numbers[9][1][x] = n9b[x];
  }
}

void showScore(int dig1,int dig2) {
  byte result[8];
  for(int p=0;p<8;p++) {
    result[p]=numbers[dig1][0][p]^numbers[dig2][1][p];
  }
  gamer.printImage(result);
}

void Reset_Licht()
{
asm volatile ("  jmp 0");  
}  
