import java.awt.datatransfer.*;
import java.awt.Toolkit;
int s = 50;
int[][] canvas = new int[8][8];
void setup(){
  size(8*s,8*s);stroke(127);
}
void draw(){
  if(mousePressed) canvas[mouseX/s][mouseY/s] = keyPressed ? 0 : 1;
  for(int y = 0; y < 8; y++){
    for(int x = 0; x < 8; x++){
      fill(canvas[x][y] * 255); 
      rect(x*s,y*s,s,s);
    }
  }
  pushStyle();fill(0,192,0);text("press SPACE to clear\npress 'i' to invert\nSHIFT+click to erase\npress 's' to save\npress 'c' to copy to clipboard",5,15);popStyle();
}
void keyReleased(){
  if(key == 'c') copyToClipboard();
  if(key == 's') saveFile();
  if(key == ' ') for(int y = 0; y < 8; y++) for(int x = 0; x < 8; x++) canvas[x][y] = 0;
  if(key == 'i') for(int y = 0; y < 8; y++) for(int x = 0; x < 8; x++) canvas[x][y] = 1-canvas[x][y];
}
void saveFile(){
  String name = (String)javax.swing.JOptionPane.showInputDialog(frame, "name your creation", "Save Gamer image", javax.swing.JOptionPane.PLAIN_MESSAGE);
  if(name != null) saveToDisk(name+".txt");
}
String[] getCode(String var){
  String[] out = new String[8];
  out[0] = "byte "+var+"[8] = {";
  for(int y = 0; y < 8; y++){
    String line = "B";
    for(int x = 0; x < 8; x++) line += canvas[x][y];
    if(y == 0) out[y] += line + ",";
    else       out[y] = line+(y < 7 ? "," : "");
  }
  out[7] += "};\n";
  return out;
}
void saveToDisk(String file){
  saveStrings(file, getCode(file));
  println(file+" ready!");
}
void copyToClipboard(){
  String name = (String)javax.swing.JOptionPane.showInputDialog(frame, "name your creation", "Copy Gamer image to clipboard", javax.swing.JOptionPane.PLAIN_MESSAGE);
  if(name != null) {
    StringSelection stringSelection = new StringSelection (join(getCode(name),"\n"));
    Clipboard clpbrd = Toolkit.getDefaultToolkit ().getSystemClipboard ();
    clpbrd.setContents (stringSelection, null);
  }
}
