/* Elfmeter 0.1 für DIY Gamer Kit V1

v0.1
---
Funktionen:
links, rechts, vorne, unten = Schuss
Trefferanzeige rechts
Bei 5 Treffern Ende, Anzahl der Versuche werden angezeigt (Score-Funktion aus Snake-Beispiel abgespeckt)
Start = Neustart

©Tobi
Web: http://www.topfree.de/thema/spielereien/diy-gamer-kit */

#include <Gamer.h>

Gamer gamer;

// Startbildschirm
byte elfmeter_start[8] = {
B10000010,
B00000000,
B00000000,
B00000000,
B00000000,
B00000000,
B00000000,
B00010000};

byte elfmeter_start_1[8] = {
B10000010,
B00000000,
B00000001,
B00000000,
B00000000,
B00000000,
B00000000,
B00010000};

byte elfmeter_start_2[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000000,
B00000000,
B00000000,
B00010000};

byte elfmeter_start_3[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B00000000,
B00000000,
B00010000};

byte elfmeter_start_4[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B00000001,
B00000000,
B00010000};

// Schuss vorne
byte elfmeter_vorne[8] = {
B10000010,
B00000000,
B00000000,
B00000000,
B00000000,
B00010000,
B00010000,
B00010000};

byte elfmeter_vorne_1[8] = {
B10000010,
B00000000,
B00000001,
B00000000,
B00000000,
B00010000,
B00010000,
B00010000};

byte elfmeter_vorne_2[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000000,
B00010000,
B00010000,
B00010000};

byte elfmeter_vorne_3[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B00010000,
B00010000,
B00010000};

byte elfmeter_vorne_4[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B00010001,
B00010000,
B00010000};

// Schuss rechts
byte elfmeter_rechts[8] = {
B10000010,
B00000000,
B00000000,
B00000000,
B00000000,
B00000100,
B00001000,
B00010000};

byte elfmeter_rechts_1[8] = {
B10000010,
B00000000,
B00000001,
B00000000,
B00000000,
B00000100,
B00001000,
B00010000};

byte elfmeter_rechts_2[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000000,
B00000100,
B00001000,
B00010000};

byte elfmeter_rechts_3[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B00000100,
B00001000,
B00010000};

byte elfmeter_rechts_4[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B00000101,
B00001000,
B00010000};

//Schuss links
byte elfmeter_links[8] = {
B10000010,
B00000000,
B00000000,
B00000000,
B00000000,
B01000000,
B00100000,
B00010000};

byte elfmeter_links_1[8] = {
B10000010,
B00000000,
B00000001,
B00000000,
B00000000,
B01000000,
B00100000,
B00010000};

byte elfmeter_links_2[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000000,
B01000000,
B00100000,
B00010000};

byte elfmeter_links_3[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B01000000,
B00100000,
B00010000};

byte elfmeter_links_4[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B01000001,
B00100000,
B00010000};

// Toranzeige only
byte elfmetertor_1[8] = {
B10000010,
B00000000,
B00000001,
B00000000,
B00000000,
B00000000,
B00000000,
B00010000};

byte elfmetertor_2[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000000,
B00000000,
B00000000,
B00010000};

byte elfmetertor_3[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B00000000,
B00000000,
B00010000};

byte elfmetertor_4[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B00000001,
B00000000,
B00010000};

byte elfmetertor_5[8] = {
B10000010,
B00000000,
B00000001,
B00000001,
B00000001,
B00000001,
B00000001,
B00010000};

byte numbers[10][2][8];
byte n1[8],n1b[8],n2[8],n2b[8],n3[8],n3b[8],n4[8],n4b[8],n5[8],n5b[8],n6[8],n6b[8],n7[8],n7b[8],n8[8],n8b[8],n9[8],n9b[8],n0[8],n0b[8];

int oben, rechts, links, punkte = 0, versuche = 0;
long treffer;

void setup() {
  Serial.begin(9600);
  gamer.begin();
  gamer.printImage(elfmeter_start);
  randomSeed(analogRead(0));
  setupScore();
}

void loop() {
  
   treffer = random(2);
   Serial.println(treffer);
  
  // Buttons gedrückt?
  if(gamer.isPressed(UP)){
  if (punkte == 0)
  gamer.printImage(elfmeter_vorne);
  if (punkte == 1)
  gamer.printImage(elfmeter_vorne_1);
  if (punkte == 2)
  gamer.printImage(elfmeter_vorne_2);
  if (punkte == 3)
  gamer.printImage(elfmeter_vorne_3);
  if (punkte == 4)
  gamer.printImage(elfmeter_vorne_4);
  
  oben = 1; rechts = 0; links = 0; 
  }
  
  if(gamer.isPressed(RIGHT)){
  if (punkte == 0)
  gamer.printImage(elfmeter_rechts);
  if (punkte == 1)
  gamer.printImage(elfmeter_rechts_1);
  if (punkte == 2)
  gamer.printImage(elfmeter_rechts_2);
  if (punkte == 3)
  gamer.printImage(elfmeter_rechts_3);
  if (punkte == 4)
  gamer.printImage(elfmeter_rechts_4);
    
  oben = 0; rechts = 1; links = 0; 
  }
  
  if(gamer.isPressed(LEFT)){
  if (punkte == 0)
  gamer.printImage(elfmeter_links);
  if (punkte == 1)
  gamer.printImage(elfmeter_links_1);
  if (punkte == 2)
  gamer.printImage(elfmeter_links_2);
  if (punkte == 3)
  gamer.printImage(elfmeter_links_3);
  if (punkte == 4)
  gamer.printImage(elfmeter_links_4);
  
  oben = 0; rechts = 0; links = 1; 
  }
  
  //Schuss!!! Tor?
  if(gamer.isPressed(DOWN)){
    
    // Schuss oben
    if(oben == 1 && punkte == 0)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_1);
      punkte = 1;}
    else
      gamer.printImage(elfmeter_start);
      versuche ++;
    }
    
    else if(oben == 1 && punkte == 1)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_2);
      punkte = 2;}
    else
      gamer.printImage(elfmeter_start_1);
      versuche ++;
    }
    
    else if(oben == 1 && punkte == 2)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_3);
      punkte = 3;}
    else
      gamer.printImage(elfmeter_start_2);
      versuche ++;
    }
    
    else if(oben == 1 && punkte == 3)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_4);
      punkte = 4;}
    else
      gamer.printImage(elfmeter_start_3);
      versuche ++;
    }
    
    else if(oben == 1 && punkte == 4)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_5);
      punkte = 5;
      delay (3000);}
    else
      gamer.printImage(elfmeter_start_4);
      versuche ++;
    }
    
    // Schuss rechts
    if(rechts == 1 && punkte == 0)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_1);
      punkte = 1;}
    else
      gamer.printImage(elfmeter_start);
      versuche ++;
    }
    
    else if(rechts == 1 && punkte == 1)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_2);
      punkte = 2;}
    else
      gamer.printImage(elfmeter_start_1);
      versuche ++;
    }
    
    else if(rechts == 1 && punkte == 2)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_3);
      punkte = 3;}
    else
      gamer.printImage(elfmeter_start_2);
      versuche ++;
    }
    
    else if(rechts == 1 && punkte == 3)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_4);
      punkte  = 4;}
    else
      gamer.printImage(elfmeter_start_3);
      versuche ++;
    }
    
    else if(rechts == 1 && punkte == 4)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_5);
      punkte = 5;
      delay (3000);}
    else
      gamer.printImage(elfmeter_start_4);
      versuche ++;
    }
    
    // Schuss links
    if(links == 1 && punkte == 0)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_1);
      punkte = 1;}
    else
      gamer.printImage(elfmeter_start);
      versuche ++;
    }
    
    else if(links == 1 && punkte == 1)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_2);
      punkte = 2;}
    else
      gamer.printImage(elfmeter_start_1);
      versuche ++;
    }
    
    else if(links == 1 && punkte == 2)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_3);
      punkte = 3;}
    else
      gamer.printImage(elfmeter_start_2);
      versuche ++;
    }
    
    else if(links == 1 && punkte == 3)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_4);
      punkte = 4;}
    else
      gamer.printImage(elfmeter_start_3);
      versuche ++;
    }
    
    else if(links == 1 && punkte == 4)
    {
    if(treffer == 1){
      gamer.printImage(elfmetertor_5);
      punkte = 5;
      delay (3000);}
    else
      gamer.printImage(elfmeter_start_4);
      versuche ++;
    }
    
   oben = 0; rechts = 0; links = 0;
 }
 
 if (punkte == 5)
 {
          int dig2 = versuche % 10;  //split score into two digits (eg 10 -> 1 and 0)
          int dig1 = (versuche-(versuche%10))/10;
          showScore(dig1,dig2);
          delay(500);
 }
 
 if(gamer.isPressed(START))
 {
   gamer.printImage(elfmeter_start);
   treffer = 0;
   punkte = 0;
   versuche = 0;
   oben = 0; rechts = 0; links = 0;
 }
 
}

// Versuchsanzeige (aus Snake-Beispiel angepasst)
void setupScore() {
  n1[0] = B10000000;
  n1[1] = B10000000;
  n1[2] = B10000000;
  n1[3] = B10000000;
  n1[4] = B10000000;
  n1[5] = B10000000;
  n1[6] = B10000000;
  n1[7] = B10000000;

  n1b[0] = B00000100;
  n1b[1] = B00000100;
  n1b[2] = B00000100;
  n1b[3] = B00000100;
  n1b[4] = B00000100;
  n1b[5] = B00000100;
  n1b[6] = B00000100;
  n1b[7] = B00000100;

  n2[0] = B11100000;
  n2[1] = B00100000;
  n2[2] = B00100000;
  n2[3] = B11100000;
  n2[4] = B10000000;
  n2[5] = B10000000;
  n2[6] = B10000000;
  n2[7] = B11100000;

  n2b[0] = B00000111;
  n2b[1] = B00000001;
  n2b[2] = B00000001;
  n2b[3] = B00000111;
  n2b[4] = B00000100;
  n2b[5] = B00000100;
  n2b[6] = B00000100;
  n2b[7] = B00000111;

  n3[0] = B11100000;
  n3[1] = B00100000;
  n3[2] = B00100000;
  n3[3] = B01100000;
  n3[4] = B00100000;
  n3[5] = B00100000;
  n3[6] = B00100000;
  n3[7] = B11100000;

  n3b[0] = B00000111;
  n3b[1] = B00000001;
  n3b[2] = B00000001;
  n3b[3] = B00000011;
  n3b[4] = B00000001;
  n3b[5] = B00000001;
  n3b[6] = B00000001;
  n3b[7] = B00000111;

  n4[0] = B10100000;
  n4[1] = B10100000;
  n4[2] = B10100000;
  n4[3] = B11100000;
  n4[4] = B00100000;
  n4[5] = B00100000;
  n4[6] = B00100000;
  n4[7] = B00100000;

  n4b[0] = B00000101;
  n4b[1] = B00000101;
  n4b[2] = B00000101;
  n4b[3] = B00000111;
  n4b[4] = B00000001;
  n4b[5] = B00000001;
  n4b[6] = B00000001;
  n4b[7] = B00000001;

  n5[0] = B11100000;
  n5[1] = B10000000;
  n5[2] = B10000000;
  n5[3] = B11100000;
  n5[4] = B00100000;
  n5[5] = B00100000;
  n5[6] = B00100000;
  n5[7] = B11100000;

  n5b[0] = B00000111;
  n5b[1] = B00000100;
  n5b[2] = B00000100;
  n5b[3] = B00000111;
  n5b[4] = B00000001;
  n5b[5] = B00000001;
  n5b[6] = B00000001;
  n5b[7] = B00000111;

  n6[0] = B11100000;
  n6[1] = B10000000;
  n6[2] = B10000000;
  n6[3] = B11100000;
  n6[4] = B10100000;
  n6[5] = B10100000;
  n6[6] = B10100000;
  n6[7] = B11100000;

  n6b[0] = B00000111;
  n6b[1] = B00000100;
  n6b[2] = B00000100;
  n6b[3] = B00000111;
  n6b[4] = B00000101;
  n6b[5] = B00000101;
  n6b[6] = B00000101;
  n6b[7] = B00000111;

  n7[0] = B11100000;
  n7[1] = B00100000;
  n7[2] = B00100000;
  n7[3] = B00100000;
  n7[4] = B00100000;
  n7[5] = B00100000;
  n7[6] = B00100000;
  n7[7] = B00100000;

  n7b[0] = B00000111;
  n7b[1] = B00000001;
  n7b[2] = B00000001;
  n7b[3] = B00000001;
  n7b[4] = B00000001;
  n7b[5] = B00000001;
  n7b[6] = B00000001;
  n7b[7] = B00000001;

  n8[0] = B11100000;
  n8[1] = B10100000;
  n8[2] = B10100000;
  n8[3] = B11100000;
  n8[4] = B10100000;
  n8[5] = B10100000;
  n8[6] = B10100000;
  n8[7] = B11100000;

  n8b[0] = B00000111;
  n8b[1] = B00000101;
  n8b[2] = B00000101;
  n8b[3] = B00000111;
  n8b[4] = B00000101;
  n8b[5] = B00000101;
  n8b[6] = B00000101;
  n8b[7] = B00000111;

  n9[0] = B11100000;
  n9[1] = B10100000;
  n9[2] = B10100000;
  n9[3] = B11100000;
  n9[4] = B00100000;
  n9[5] = B00100000;
  n9[6] = B00100000;
  n9[7] = B11100000;

  n9b[0] = B00000111;
  n9b[1] = B00000101;
  n9b[2] = B00000101;
  n9b[3] = B00000111;
  n9b[4] = B00000001;
  n9b[5] = B00000001;
  n9b[6] = B00000001;
  n9b[7] = B00000111;

  n0[0] = B11100000;
  n0[1] = B10100000;
  n0[2] = B10100000;
  n0[3] = B10100000;
  n0[4] = B10100000;
  n0[5] = B10100000;
  n0[6] = B10100000;
  n0[7] = B11100000;

  n0b[0] = B00000111;
  n0b[1] = B00000101;
  n0b[2] = B00000101;
  n0b[3] = B00000101;
  n0b[4] = B00000101;
  n0b[5] = B00000101;
  n0b[6] = B00000101;
  n0b[7] = B00000111;

  for(int x=0;x<8;x++) {
    numbers[0][0][x] = n0[x];
    numbers[1][0][x] = n1[x];
    numbers[2][0][x] = n2[x];
    numbers[3][0][x] = n3[x];
    numbers[4][0][x] = n4[x];
    numbers[5][0][x] = n5[x];
    numbers[6][0][x] = n6[x];
    numbers[7][0][x] = n7[x];
    numbers[8][0][x] = n8[x];
    numbers[9][0][x] = n9[x];
    numbers[0][1][x] = n0b[x];
    numbers[1][1][x] = n1b[x];
    numbers[2][1][x] = n2b[x];
    numbers[3][1][x] = n3b[x];
    numbers[4][1][x] = n4b[x];
    numbers[5][1][x] = n5b[x];
    numbers[6][1][x] = n6b[x];
    numbers[7][1][x] = n7b[x];
    numbers[8][1][x] = n8b[x];
    numbers[9][1][x] = n9b[x];
  }
}

void showScore(int dig1,int dig2) {
  byte result[8];
  for(int p=0;p<8;p++) {
    result[p]=numbers[dig1][0][p]^numbers[dig2][1][p];
  }
  gamer.printImage(result);
}
